<?php

/*
   ###########################################################################
   Stellar Brightness Ratio Calculator - WITH 30-DAY COOKIE

   Given the stellar magnitudes of two astronomical objects, this program
   computes the actual brightness ratio between them.

   This version uses a PRE block for output, rather than a TEXTAREA.

   AUTHOR   : Jay Tanner - 2024
   LANGUAGE : PHP v7.4.9
   LICENSE  : Public Domain

  ###########################################################################
*/

   ob_start(); // Yes, Santa Claus, there was a Virginia.

// ---------------------------------------------------------------
// Define the program cookie name and set it to expire in 30 days.

   $CookieName = 'Stellar-Magnitude-Brightness-Ratio-Calculator';
   $SetToExpireIn30Days = time() + 30*86400;


// ---------------------------------
// Define PHP program and HTML info.

   $_AUTHOR_           = 'Jay Tanner';
   $_PROGRAM_VERSION_  = 'v1.00 - '; $at = "&#97;&#116;&#32;&#76;&#111;&#99;&#97;&#108;&#32;&#84;&#105;&#109;&#101;&#32;"; $LTC = "&#85;&#84;&#67;";
   $_SCRIPT_FILE_PATH_ = Filter_Input(INPUT_SERVER, 'SCRIPT_FILENAME');
   $_REVISION_DATE_    = $_PROGRAM_VERSION_ .'Revised: '. date("Y-F-d-l $at h:i:s A   ($LTC", FileMTime($_SCRIPT_FILE_PATH_))."&minus;05:00)";
   $_BROWSER_TAB_TEXT_ = "Stellar Magnitude Brightness Ratio Calculator";
   $_INTERFACE_TITLE_  = "<span style='font-size:14pt;'>Stellar Magnitude Brightness Ratio Calculator</span><br><br><span style='font-size:11pt;'>PHP Program by Jay Tanner</span>";


// -------------------------------------
// Define main TextArea text and background
// colors and HTML table row span. If an
// error is reported, then these colors
// will change internally to red/white.

   $TxColor = 'black';
   $BgColor = 'white';


// ---------------------------------------------
// Do this only if [SUBMIT] button was clicked.

   $w = Filter_Input(INPUT_POST, 'SubmitButton');

   if (!IsSet($w))
  {

// ----------------------------------------------------------------------
// If this program is being called externally, rather than being executed
// by clicking the [SUBMIT] button, and an active cookie also exists,
// then restore the previously saved interface settings from it. If
// the user leaves and comes back later, all the interface settings
// will be remembered and restored if the cookie was not deleted.

   $w = Filter_Input(INPUT_COOKIE, $CookieName);

   if (IsSet($w))
      {
       $CookieDataString = Filter_Input(INPUT_COOKIE, $CookieName);
       list($Mag1,$Mag2) = Preg_Split("[\|]", $CookieDataString);
      }

   else

// -----------------------------------------------------------
// If there is no previous cookie with the interface settings,
// then set the initial default interface startup values and
// store them in a new cookie.

 {
   $Mag1 = '0.000';
   $Mag2 = '0.000';

// -------------------------------------------
// Store current interface settings in cookie.

   $CookieDataString = "$Mag1|$Mag2";
   SetCookie ($CookieName, $CookieDataString, $SetToExpireIn30Days);
  } // End of  else {...}

  } // End of  if (!isset(_POST['SubmitButton']))


// ------------------------------------------
// Read values of all interface arguments and
// set any empty arguments to default values.

   $w = Filter_Input(INPUT_POST, 'SubmitButton');

   if (isset($w))
{
   $Mag1 = trim(Filter_Input(INPUT_POST, 'Mag1'));
           if ($Mag1 == '') {$Mag1 = '0.000';}

   $Mag2 = trim(Filter_Input(INPUT_POST, 'Mag2'));
           if ($Mag2 == '') {$Mag2 = '0.000';}

// -------------------------------------
// Store interface argument in a cookie.

   $CookieDataString = "$Mag1|$Mag2";
   SetCookie ($CookieName, $CookieDataString, $SetToExpireIn30Days);
}


// ----------------------------------------------
// Optionally check argument values for validity.
// If error, set error flag and message values.

   $ErrFlag = FALSE;
   $ErrMssg = '';

   if (!Is_Numeric($Mag2))
      {
       $ErrFlag = TRUE;
       $ErrMssg = "Invalid magnitude value detected.\n'$Mag2'\nBoth magnitude values must be purely numeric.";
      }

   if (!Is_Numeric($Mag1))
      {
       $ErrFlag = TRUE;
       $ErrMssg = "Invalid magnitude value detected.\n'$Mag1'\nBoth magnitude values must be purely numeric.";
      }


// -----------------------------
// Set initial uniform width for
// tables alignment in pixels.

   $TableWidth = '520';


// ******************************************
// ******************************************
// If error was reported (TRUE), then display
// the error message on a red background.

   if ($ErrFlag === TRUE)
  {
   $TxColor = 'white';
   $BgColor = '#CC0000';
   $TextArea2Text = '';

   $TextArea1Text =
"=== ERROR ===

$ErrMssg";
  }

else


  {
// *********************************************************
// BEGIN MAIN COMPUTATIONS HERE IF NO ERRORS DETECTED ABOVE.
// *********************************************************

   $k = Pow(100, 1/5);

// Compute difference in magnitudes.
   $dM = abs(trim($Mag1) - trim($Mag2));

// Compute brightness ratio between magnitudes.
   $bRatio = Pow($k, $dM);

   $bRatio = Number_Format($bRatio, 3);

   $xMag1 = SPrintF("% +8.3f", $Mag1);
   $xMag2 = SPrintF("% +8.3f", $Mag2);


// Determine which magnitude is brighter.

   if ($Mag1 < $Mag2)
   {
    $OutText = "   m<sub>1</sub> = $bRatio times\n        brighter than m<sub>2</sub>";
   }
   else
   {
    $OutText = "   m<sub>2</sub> = $bRatio times\n        brighter than m<sub>1</sub>";
   }

   if ($Mag1 == $Mag2)
      {
       $OutText = "   m<sub>1</sub>  and  m<sub>2</sub>  are equal in brightness.";
      }






// ----------------------------------
// Computation or function call code.





// *******************************************
// DROP THROUGH HERE AFTER COMPUTATIONS ABOVE
// TO PRINT OUT THE RESULTS OF THE OPERATIONS.
// *******************************************

   $TextArea1Text =
"   BRIGHTNESS RATIO BETWEEN TWO STELLAR MAGNITUDES

   m<sub>1</sub> =$xMag1
   m<sub>2</sub> =$xMag2

$OutText
";
  }


// ****************************
// Define TextArea2 text block.

   $TextArea2Text =
"TEXT AREA 2 = OPTIONAL SECOND TEXT AREA

For optional program info or other use or
it can be removed entirely.
";



// **************************************************************************
// Determine number of text columns and rows to use in the output text areas.
// These values vary randomly according to the text block width and length.
// The idea is to eliminate the need for scroll-bars within the text areas
// or worry as much about the variable dimensions of a text display area.

// --------------------------------------------
// Text Area 1 - Default = At least 80 columns.

   $Text1Cols = 1 + Max(Array_Map('StrLen', PReg_Split("[\n]", trim($TextArea1Text))));
   if ($Text1Cols < 80) {$Text1Cols = 60;}  // Default
   $Text1Rows = 2 + Substr_Count($TextArea1Text, "\n");

// --------------------------------------------
// Text Area 2 - Default = At least 80 columns.

   $Text2Cols = 1 + Max(Array_Map('StrLen', PReg_Split("[\n]", trim($TextArea2Text))));
   if ($Text2Cols < 80) {$Text2Cols = 80;} // Default
   $Text2Rows = 2 + Substr_Count($TextArea2Text, "\n");



// ******************************************
// ******************************************
// GENERATE CLIENT WEB PAGE TO DISPLAY OUTPUT

   print <<< _HTML

<!DOCTYPE HTML>
<HTML>

<head>
<title>$_BROWSER_TAB_TEXT_</title>

<meta name='viewport' content='width=device-width, initial-scale=0.8'>

<meta http-equiv='content-type' content='text/html; charset=UTF-8'>
<meta http-equiv='pragma'  content='no-cache'>
<meta http-equiv='expires' content='-1'>
<meta name='description' content='xxxxxxxxxxxxxxx'>
<meta name='keywords' content='PHPScienceLabs.com'>
<meta name='author' content='Jay Tanner - https://www.PHPScienceLabs.com'>
<meta name='robots' content='index,follow'>
<meta name='googlebot' content='index,follow'>

<style>

 BODY {color:white; background:black; font-family:Verdana; font-size:12pt; line-height:125%;}

 TABLE
{font-size:13pt; border: 1px solid black;}


 TD
{
 color:black; background:white; line-height:150%; font-size:10pt;
 padding:6px; text-align:center;
}


 UL
{font-family:Verdana; font-size:12pt; line-height:150%; text-align:justify;}


 PRE
{
 background:white; color:black; font-family:monospace; font-size:12.5pt;
 font-weight:bold; text-align:left; line-height:125%; padding:6px;
 border:2px solid black; border-radius:8px;
 page-break-before:page;
}


 DIV
{
 background:white; color:black; font-family:Verdana; font-size:11pt;
 font-weight:normal; line-height:125%; padding:6px;
}


 TEXTAREA
{
 background:white; color:black; font-family:monospace; font-size:13pt;
 font-weight:bold; padding:4pt; white-space:pre; border-radius:8px;
 line-height:125%;
}


 INPUT[type='text']::-ms-clear {width:0; height:0;}

 INPUT[type='text']
{
 font-family:monospace; color:black; background:white; font-size:13pt;
 font-weight:bold; text-align:center; box-shadow:2px 2px 3px #666666;
 border:2px solid black; border-radius:4px;
}
 INPUT[type='text']:focus
{
 font-family:monospace; background:white; box-shadow:2px 2px 3px #666666;
 font-size:13pt; border:2px solid blue; text-align:center; font-weight:bold;
 border-radius:4px;
}



 INPUT[type='submit']
{
 background:black; color:cyan; font-family:Verdana; font-size:10pt;
 font-weight:bold; border-radius:4px; border:4px solid #777777;
 padding:3pt;
}
 INPUT[type='submit']:hover
{
 background:black; color:white; font-family:Verdana; font-size:10pt;
 font-weight:bold; border-radius:4px; border:4px solid red;
 padding:3pt;
}





// Link states MUST be set in the following order:
// :link, :visited, :hover, :active

 A:link
{
 font-size:10pt; background:transparent; color:#8080FF; border-radius:4px;
 font-family:Verdana; font-weight:bold; text-decoration:none;
 line-height:175%; padding:3px; border:1px solid transparent;
}
 A:visited
{
 font-size:10pt; background:transparent; color:DarkCyan; border-radius:4px;
}
 A:hover
{
 font-size:10pt; background:yellow; color:black; border:1px solid black;
 box-shadow:1px 1px 3px #222222; border-radius:4px;
}
 A:active
{
 font-size:10pt; background:yellow; color:black; border-radius:4px;
}


 HR {background:red; height:4px; border:0px;}

.sub2 {font-size:4pt;}

[title-text]:hover:after
{
 opacity:1.0;
 transition:all 1.0s ease 1.0s;
 text-align:left;
 visibility:visible;
}

[title-text]:after
{
 opacity:1.0;
 content:attr(title-text);
 text-align:left;
 left:50%;
 background-color:yellow;
 color:black;
 font-size:10pt;
 position:absolute;
 padding:1px 5px 2px 5px;
 white-space:pre;
 border:1px solid red;
 z-index:1;
 visibility:hidden;
}

[title-text] {position: relative;}


::selection{background-color:yellow !important; color:black !important;}
::-moz-selection{background-color:yellow !important; color:black !important;}
</style>

</head>

<body>

<!-- Define container form --->
<form name="form1" method="post" action="">

<!-- Define main page title/header. --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">


<tr><td colspan="99" style="color:white; background-color:#000066; border:2px solid white; border-radius:8px 8px 0px 0px;">$_INTERFACE_TITLE_</td></tr>
</table>


<!-- Define input text box (Mag1, Mag2) --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr><td style="line-height:175%;"><b>m</b><sub>1</sub>&nbsp;=&nbsp;<input name="Mag1"  type="text" value="$Mag1"  size="8" maxlength="7">
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>m</b><sub>2</sub>&nbsp;=&nbsp;<input name="Mag2"  type="text" value="$Mag2"  size="8" maxlength="7">
</td></tr>
</table>


<!-- Define [SUBMIT] button --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr><td colspan="99" style="background-color:black;"><input type="submit" name="SubmitButton" value=" S U B M I T "></td></tr>

<tr>
<td colspan='3' style='background:transparent; color:black; font-size:10pt;
                       text-align:center;'>
                       &nbsp;
<a href='View-Source-Code.php' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>
         &nbsp;<span style='font-weight:normal;'>View/Copy PHP Source Code</span>&nbsp;
</a>
&nbsp;
<a href='Stellar-Brightness-Ratio-Calculator.7z' target='_blank'
   style='font-family:Verdana; color:black; background:yellow;
         text-decoration:none; border:1px solid black; padding:4px;
         border-radius:4px;'>&nbsp;
         <span style='font-weight:normal;'>Download this PHP Program</span>&nbsp;
</a>
</td>
</tr>


</table>


<!-- Define TextArea1 --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="text-align:center; color:GreenYellow; background-color:black;"><br>
<pre>
$TextArea1Text
</pre>

<!--
<textarea ID="TextArea1" name="TextArea1" style="color:$TxColor; background:$BgColor; padding:6px; border:2px solid white;" cols="$Text1Cols" rows="$Text1Rows" ReadOnly OnDblClick="this.select();" OnMouseUp="return true;">
$TextArea1Text
</textarea>
--->

</td>
</tr>
</table>


<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td style='background:white;'>
Given two stellar magnitudes (<i>m<sub>1</sub></i>) and (<i>m<sub>2</sub></i>) the brightness<br>
ratio (<i>bRatio</i>) between the brighter and fainter magnitude is:
<br><br>
<img src='images/bRatio.png'>
</td>
</tr>
</table>



<!-- Define TextArea2
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="text-align:center; color:GreenYellow; background:black;">Double-Click Within Text Area to Select ALL Text<br>
<textarea ID="TextArea2" name="TextArea2" style="color:black; background:white; padding:6px;" cols="$Text2Cols" rows="$Text2Rows" ReadOnly OnDblClick="this.select();" OnMouseUp="return true;">
$TextArea2Text
</textarea>
</tr>
</table>
--->

<!-- Define page footer --->
<table width="$TableWidth" align="center" border="0" cellspacing="1" cellpadding="3">
<tr>
<td colspan="99" style="color:GreenYellow; background:black;">PHP Program by $_AUTHOR_<br><span style="color:silver; background:black;">$_REVISION_DATE_</span></td>
</tr>
</table>

</form>
<!-- End of container form --->


<!-- Extra bottom scroll space --->
<br><br><br><br><br><br><br><br><br><br><br><br>
<br><br><br><br><br><br><br><br><br><br><br><br>

</body>
</HTML>



_HTML;

// END OF PROGRAM

?>


